##   Importance of Secure Network Communications

- Secure communications are critical to defend against threats such as:
    - DoS attacks
    - Man-in-the-middle attacks
    - Masquerading
    - Other malicious activities

---

## MACsec: Securing Wired LAN Communications

### What is MACsec?

- MACsec (Media Access Control Security) provides encryption and authentication for packets on wired LANs.
- Encrypts each packet using symmetric key cryptography, making data unreadable and unalterable on the wire.
- Can protect Security Group Tags (SGTs) along with data payloads.

### Key Features

- Defined in IEEE 802.1AE.
- Provides:
    - Confidentiality
    - Integrity
    - Flexibility
    - Network intelligence
- Secures various protocol traffic (e.g., ARP, DHCP).

---

## Cisco TrustSec and MACsec Integration

- **Cisco TrustSec** combines SGTs and MACsec for simplified secure access management.
- Supports 802.1AE encryption with the MACsec Key Agreement (MKA) protocol.
- Supports switch-to-host (downlink) and switch-to-switch (trunk) encryption.

### Protocols and Standards

- Uses AES-128 GCM and GMAC for encryption/authentication.
- Compliant with 802.1AE standard.

---

## MACsec Key Agreement (MKA) and Security Association Protocol (SAP)

- **MKA Protocol:**
    - Provides session keys and manages encryption keys for switch-to-host encryption.
    - Works after IEEE 802.1X EAP authentication.
- **SAP (Security Association Protocol):**
    - Used for switch-to-switch (trunk) security.
    - Negotiates cipher suite and keys using EAPOL.

### Limitations

- SAP is not supported on:
    - Host-facing access ports
    - Switch virtual interfaces
    - SPAN destination ports

---

## Operational Modes for Cisco TrustSec NDAC SAP

- **gcm-encrypt**: Authentication and encryption
- **gmac**: Authentication only, no encryption
- **no-encap**: No encapsulation
- **null**: Encapsulation only, no authentication or encryption

---

## Configuration Approaches

### 802.1X Mode

- Set up global 802.1X and RADIUS AAA on the seed (closest to RADIUS) switch.
- Configure SAP operation mode.
- Non-seed devices authenticate to the seed switch.

### Manual Mode

- Use if authentication server/802.1X is not available.
- Manually configure SAP parameters and operation mode on both ends.

#### Example Manual Mode Configuration

- Enter interface configuration:
    - `cts manual`
    - `no propagate sgt` (if peer can’t process SGTs)
    - `sap pmk<key> mode-list gcm-encrypt` (set key and mode)

---

## Verification of MACsec Encryption

### Key Verification Commands

- **show cts interface**:  
    Displays TrustSec-related settings and operational status.
- **show mka policy**:  
    Displays MKA policy entries.
- **show authentication session**:  
    Shows authorized session security status.

#### Example Output Highlights

- Interface mode (manual/802.1X)
- Authentication and SAP status
- Cipher suite in use
- Replay protection status
- SGT propagation status

---

## Key Takeaways

- MACsec provides strong Layer 2 security for wired LANs by encrypting and authenticating all packets.
- Cisco TrustSec integrates MACsec and SGTs for comprehensive, manageable network security.
- Supports both automated (802.1X) and manual configuration modes.
- Verification commands help ensure and monitor secure configurations.